package maze;

public interface IRoomData {
  
  public <R, P> R execute(IRoomDataAlgo<R,P> algo, P... inps);

  public static final IRoomData END = new IRoomData() {
    public <R, P> R execute(IRoomDataAlgo<R,P> algo, P... inps){
      return algo.endCase(this, inps);
    }
    public String toString() {
      return "End";
    }
  };
  public static final IRoomData UNSEEN = new IRoomData() {
    public <R, P> R execute(IRoomDataAlgo<R,P> algo, P... inps){
      return algo.unseenCase(this, inps);
    }
    public String toString() {
      return "Unseen";
    }
  };
  public static final IRoomData SEEN = new IRoomData() {
    public <R, P> R execute(IRoomDataAlgo<R,P> algo, P... inps){
      return algo.seenCase(this, inps);
    }
    public String toString() {
      return "Seen";
    }
  };

}
